/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.part;

import appeng.api.parts.IPart;
import appeng.core.localization.WailaText;
import appeng.integration.modules.waila.part.BasePartWailaDataProvider;
import appeng.parts.networking.IUsedChannelProvider;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public final class ChannelWailaDataProvider
extends BasePartWailaDataProvider {
    private static final String ID_USED_CHANNELS = "usedChannels";
    private static final String ID_MAX_CHANNELS = "maxChannels";
    private final TObjectIntMap<IPart> usedChannelsCache = new TObjectIntHashMap();
    private final TObjectIntMap<IPart> maxChannelsCache = new TObjectIntHashMap();

    @Override
    public List<String> getWailaBody(IPart part, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (part instanceof IUsedChannelProvider) {
            int usedChannels = this.getUsedChannels(part, accessor.getNBTData());
            int maxChannels = this.getMaxChannels(part, accessor.getNBTData());
            String formattedToolTip = maxChannels <= 0 ? String.format(WailaText.ChannelsUnbound.getLocal(), usedChannels) : String.format(WailaText.Channels.getLocal(), usedChannels, maxChannels);
            currentToolTip.add(formattedToolTip);
        }
        return currentToolTip;
    }

    private int getUsedChannels(IPart part, NBTTagCompound tag) {
        int usedChannels;
        if (tag.func_74764_b(ID_USED_CHANNELS)) {
            usedChannels = tag.func_74762_e(ID_USED_CHANNELS);
            this.usedChannelsCache.put((Object)part, usedChannels);
        } else {
            usedChannels = this.usedChannelsCache.containsKey((Object)part) ? this.usedChannelsCache.get((Object)part) : 0;
        }
        return usedChannels;
    }

    private int getMaxChannels(IPart part, NBTTagCompound tag) {
        int maxChannels;
        if (tag.func_74764_b(ID_MAX_CHANNELS)) {
            maxChannels = tag.func_74762_e(ID_MAX_CHANNELS);
            this.maxChannelsCache.put((Object)part, maxChannels);
        } else {
            maxChannels = this.maxChannelsCache.containsKey((Object)part) ? this.maxChannelsCache.get((Object)part) : 0;
        }
        return maxChannels;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, IPart part, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (part instanceof IUsedChannelProvider) {
            IUsedChannelProvider channelProvider = (IUsedChannelProvider)part;
            tag.func_74768_a(ID_USED_CHANNELS, channelProvider.getUsedChannelsInfo());
            tag.func_74768_a(ID_MAX_CHANNELS, channelProvider.getMaxChannelsInfo());
        }
        return tag;
    }
}

